/*
 * Decompiled with CFR 0.152.
 */
package strategies.ai;

import core.states.GameState;
import entities.Entity;
import entities.creatures.enemies.LuxEntity;
import entities.missiles.sona.SonaAbilityREntity;
import java.util.ArrayList;
import strategies.ai.Ai;
import util.ResourceManager;

public final class LuxAi
extends Ai {
    private SonaAbilityREntity sonaR = null;
    private int lastSonaRY = 0;

    private void doUltiLogic() {
        LuxEntity entity = (LuxEntity)this.entity;
        if (entity.getLastR() != null) {
            if (entity.isUltiInitTimeOver() && !entity.getLastR().isInitOver()) {
                entity.getLastR().initIsOver();
            }
            if (entity.isUltiBlastTimeOver()) {
                entity.getLastR().BlastIsOver();
                entity.resetLastR();
            }
        }
    }

    @Override
    public void calculate() {
        LuxEntity entity = (LuxEntity)this.entity;
        if (entity.isStunned()) {
            this.doUltiLogic();
            return;
        }
        if (this.sonaR == null) {
            ArrayList<Entity> entities = GameState.get().getEntities();
            for (Entity ent : entities) {
                if (!(ent instanceof SonaAbilityREntity)) continue;
                this.sonaR = (SonaAbilityREntity)ent;
                break;
            }
        } else {
            if (this.x > 55.0 && this.x + (double)entity.getW() < ResourceManager.get().getDimension().getWidth() - 55.0) {
                this.dx = (double)(this.sonaR.getX() + this.sonaR.getW() / 2) <= this.x + (double)(entity.getW() / 2) ? entity.getMoveSpeed() * 0.5 : -entity.getMoveSpeed() * 0.5;
                this.dy = -entity.getMoveSpeed() * 0.25;
            }
            if ((double)(this.sonaR.getY() + this.sonaR.getH()) < this.y || this.sonaR.getY() == this.lastSonaRY) {
                this.sonaR = null;
            } else {
                this.lastSonaRY = this.sonaR.getY();
            }
        }
        if (entity.getLastR() == null) {
            if (this.dx < 0.0 && this.x <= 0.0 || this.dx > 0.0 && this.x >= ResourceManager.get().getDimension().getWidth() - (double)entity.getW()) {
                this.dx = -this.dx;
            }
            if (this.dy < 0.0 && this.y <= 10.0 || this.dy > 0.0 && this.y >= 300.0) {
                this.dy = -this.dy;
            }
            if (GameState.get().isAttackDelayOver()) {
                int luxShotChance;
                switch (GameState.get().getDifficulty()) {
                    case HARD: {
                        luxShotChance = 113000;
                        break;
                    }
                    case LEGENDARY: {
                        luxShotChance = 108000;
                        break;
                    }
                    default: {
                        luxShotChance = 104000;
                    }
                }
                if (this.random.nextInt(luxShotChance) > 100000) {
                    entity.useShot();
                }
                if ((int)this.x > GameState.get().getPlayer().getX() - 22 && (int)this.x < GameState.get().getPlayer().getX() + 22) {
                    entity.useAbilityQ();
                }
                entity.useAbilityW();
                if ((entity.getLastAbilityQTime() == 0L || entity.getLastAbilityQTime() + 400L < GameState.get().getTime()) && entity.isAbilityQOnCooldown() && this.y >= (double)(ResourceManager.get().getDimension().height - entity.getH() / 2 - 530) && (int)this.x > GameState.get().getPlayer().getX() - 50 && (int)this.x < GameState.get().getPlayer().getX() + 50) {
                    entity.useAbilityR();
                }
            }
        } else {
            this.doUltiLogic();
        }
    }
}

